﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using CashierCrisis.Managers;

namespace CashierCrisis.Entities
{
    public class MoodComponent: Component
    {
        public double Mood { get; set; }
        public double MoodDecayRate { get; set; }
        public double MoodGrowthRate { get; set; }
        public bool IsDecaying { get; set;}
        public bool IsGrowing { get; set; }
        public bool DisplayText = false;
        private SpriteFont font;
        private Vector2 offset = new Vector2(0, -32);
        private float totalTime = 3000f;
        private float totalTimeGrowth = 1500f;
        private float totalElapsed;
        private StatusBarComponent moodBar;


        public MoodComponent(string name)
            : base(name)
        {
           FontManager fontManager = CashierGame.Instance.Services.GetService(typeof(FontManager)) as FontManager;
           font = fontManager.GetFont("Default");
           IsDecaying = true;
          
         
        }

        public bool IsSuperHappy
        {
            get { return Mood >= 81 && Mood <= 100; }
        }

        public bool IsHappy
        {
            get { return Mood >= 61 && Mood <= 80; }
        }

        public bool IsNeutral
        {
            get { return (Mood >= 41 && Mood <= 60); }
        }

        public bool IsAngry
        {
            get { return Mood >= 21 && Mood <= 41; }
        }

        public bool IsSuperAngry
        {
            get { return Mood >= 0 && Mood < 21; }
        }

        public bool Puzzled { get; set; }

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            float elapsed = (float)gameTime.ElapsedGameTime.Milliseconds;
            totalElapsed += elapsed;
            totalTimeGrowth += elapsed;

            if (totalElapsed > totalTime)
            {
                if (!Puzzled)
                {
                    if (IsGrowing)
                    {
                        Mood += MoodGrowthRate;
                    }

                    if (IsDecaying)
                    {
                        Mood -= MoodDecayRate;
                    }
                }

                totalElapsed = 0f;
            }

        


            Mood = MathHelper.Clamp((float)Mood, 0f, 100f);
            MoodDecayRate = MathHelper.Clamp((float)MoodDecayRate, 0f, 10f);
            MoodGrowthRate = MathHelper.Clamp((float)MoodGrowthRate, 0f, 10f);

            moodBar.Current = (int)Mood;
          
        }

        public override void Draw(Microsoft.Xna.Framework.Graphics.SpriteBatch spriteBatch)
        {
            if (DisplayText)
            {
                string mood = string.Format("MD: {0}", Mood);
                spriteBatch.DrawString(font, mood, Entity.Position + offset, (IsAngry || IsSuperAngry == false) ? Color.Blue : Color.Red);
            }

            moodBar.Position = Entity.Position + new Vector2(-32, -32);
            base.Draw(spriteBatch);
        }

        public override void OnAttached(Entity entity)
        {
            moodBar = entity.GetComponent("status") as StatusBarComponent;
            moodBar.LowColor = Color.Red;
            moodBar.FillColor = Color.LimeGreen;
            moodBar.Low = 41;
            moodBar.Current = (int)Mood;
            base.OnAttached(entity);
        }

    }
}
